<?php
if (!defined("ABSPATH")) {
    exit();
}
?>
<div class="redirect-logs">
    <div class="redirect-logs__start-banner redirect-start-banner">
        <h2 class="redirect-start-banner__title">
            <?php esc_html_e("Below you see which URLs visitors tried to access, but", "redirect-redirection"); ?>
        </h2>
        <div class="redirect-start-banner__choise">
            <div class="redirect-start-banner__url-item choise-item">
                <svg width="52" height="34" id="icon-url" viewBox="0 0 52 34 class=" choise-item__icon">

                <rect width="52" height="34" rx="2.75" fill="#374785" />
                <path d="M43.2718 12.7494L41.5614 5.22348C41.4929 5.08664 41.3561 4.94979 41.2193 5.01821C41.1509 5.01821 41.0824 5.08663 41.0824 5.08663L39.3036 7.00232C35.8827 4.12878 31.0934 5.70239 28.9041 8.02859C28.7672 8.16543 28.8357 8.30227 28.9041 8.4391C29.0409 8.57594 29.1778 8.50752 29.3146 8.4391C29.8619 7.89176 34.3775 7.48126 36.909 9.60221L35.1301 11.5179C34.9933 11.6547 35.0617 11.7916 35.1301 11.9284C35.1985 11.9968 35.1985 11.9968 35.2669 11.9968L42.8613 13.0915C42.9981 13.0915 43.135 13.0231 43.2034 12.8178C43.2718 12.8178 43.2718 12.8179 43.2718 12.7494Z" fill="white" />
                <g opacity="0.4">
                <path opacity="0.4" d="M14.1942 14.7336C13.9205 14.7336 13.6469 14.9388 13.6469 15.3493C13.6469 15.7598 13.8521 15.9651 14.1942 15.9651C14.4679 15.9651 14.7415 15.7598 14.7415 15.3493C14.6731 14.9388 14.4679 14.7336 14.1942 14.7336Z" fill="white" />
                <path opacity="0.4" d="M27.8777 11.039H7.89974C5.77879 11.039 3.99994 12.7494 3.99994 14.9388C3.99994 17.1282 5.71037 18.8386 7.89974 18.8386H27.8777C29.9987 18.8386 31.7776 17.1282 31.7776 14.9388C31.7776 12.7494 29.9987 11.039 27.8777 11.039ZM9.61018 16.6492C8.78917 16.6492 8.17343 16.1019 8.17343 15.3493C8.17343 14.5967 8.78917 14.0494 9.61018 14.0494C10.4312 14.0494 11.047 14.5967 11.047 15.3493C11.047 16.1019 10.4312 16.6492 9.61018 16.6492ZM12.3469 16.5808H11.4575V13.1599H12.3469V16.5808ZM15.5625 16.5808H14.7415V16.3072C14.6047 16.5124 14.331 16.5808 13.9889 16.5808C13.3048 16.5808 12.7574 16.1019 12.7574 15.2809C12.7574 14.4599 13.3048 13.981 13.9889 13.981C14.2626 13.981 14.5363 14.0494 14.6731 14.2546V13.0915H15.5625V16.5808ZM17.4098 15.623H16.0415V14.9388H17.4098V15.623ZM20.9675 15.1441C20.9675 16.1019 20.4202 16.6492 19.4624 16.6492C18.5045 16.6492 17.9572 16.1019 17.9572 15.1441V13.3652H18.8466V15.1441C18.8466 15.6914 19.0519 15.8966 19.4624 15.8966C19.8729 15.8966 20.0781 15.6914 20.0781 15.1441V13.3652H20.9675V15.1441ZM23.6358 16.5808L23.0201 15.6914H22.5412V16.5808H21.6517V13.3652H23.1569C24.0463 13.3652 24.5937 13.8441 24.5937 14.5967C24.5937 15.0756 24.3884 15.4177 23.9779 15.623L24.6621 16.6492H23.6358V16.5808ZM27.5357 16.5808H25.0726V13.3652H25.9621V15.8966H27.5357V16.5808Z" fill="white" />
                <path opacity="0.4" d="M23.0199 14.0494H22.541V15.0072H23.0199C23.4304 15.0072 23.5673 14.802 23.5673 14.5283C23.6357 14.2546 23.4304 14.0494 23.0199 14.0494Z" fill="white" />
                <path opacity="0.4" d="M9.6102 14.7336C9.33653 14.7336 9.06287 14.9388 9.06287 15.3493C9.06287 15.7598 9.26811 15.9651 9.6102 15.9651C9.88387 15.9651 10.1576 15.7598 10.1576 15.3493C10.1576 14.9388 9.88387 14.7336 9.6102 14.7336Z" fill="white" />
                </g>
                <path d="M43.4086 26.8435H15.5626C12.6206 26.8435 10.1576 24.4489 10.1576 21.4385V21.3701C10.1576 18.4281 12.5522 15.9651 15.5626 15.9651H43.4086C46.3506 15.9651 48.8136 18.3597 48.8136 21.3701V21.4385C48.8136 24.4489 46.419 26.8435 43.4086 26.8435Z" fill="white" />
                <path d="M18.0255 21.6437V23.6278H16.794V21.849C16.794 21.37 16.5887 21.1648 16.2466 21.1648C15.8361 21.1648 15.5624 21.4385 15.5624 21.9858V23.6963H14.3309V20.1385H15.494V20.549C15.7677 20.2754 16.1782 20.1385 16.5887 20.1385C17.4097 20.0701 18.0255 20.549 18.0255 21.6437Z" fill="black" />
                <path d="M22.4042 22.191H19.8727C20.0095 22.5331 20.2832 22.7384 20.7621 22.7384C21.1042 22.7384 21.3095 22.67 21.5831 22.4647L22.1989 23.1489C21.8568 23.491 21.3779 23.6962 20.6937 23.6962C19.4622 23.6962 18.6412 22.9436 18.6412 21.9174C18.6412 20.8911 19.4622 20.1385 20.5569 20.1385C21.5831 20.1385 22.4042 20.8227 22.4042 21.9174C22.4042 21.9858 22.4042 22.1226 22.4042 22.191ZM19.8043 21.5753H21.241C21.1726 21.2332 20.899 20.9595 20.5569 20.9595C20.1464 20.9595 19.8727 21.1648 19.8043 21.5753Z" fill="black" />
                <path d="M28.6986 20.1385L27.4671 23.6278H26.304L25.6198 21.7121L24.9356 23.6278H23.7725L22.541 20.1385H23.7041L24.3883 22.2595L25.1409 20.1385H26.1671L26.9197 22.2595L27.6723 20.1385H28.6986Z" fill="black" />
                <path d="M28.8354 21.3016H30.6827V22.2595H28.8354V21.3016Z" fill="black" />
                <path d="M31.4354 21.6437V19.1122H32.7353V21.5753C32.7353 22.3279 33.0774 22.67 33.6247 22.67C34.1721 22.67 34.4457 22.3279 34.4457 21.5753V19.1122H35.6773V21.6437C35.6773 23.0121 34.9247 23.7646 33.5563 23.7646C32.2564 23.6962 31.4354 22.9436 31.4354 21.6437Z" fill="black" />
                <path d="M38.5509 22.4647H37.8667V23.6963H36.5668V19.1807H38.6193C39.8508 19.1807 40.6034 19.7964 40.6034 20.8227C40.6034 21.5069 40.2613 21.9858 39.714 22.2595L40.6718 23.6963H39.3035L38.5509 22.4647ZM38.5509 20.1385H37.8667V21.4385H38.5509C39.0982 21.4385 39.3719 21.1648 39.3719 20.7543C39.3035 20.3438 39.0982 20.1385 38.5509 20.1385Z" fill="black" />
                <path d="M41.356 19.1122H42.656V22.6016H44.7769V23.6278H41.356V19.1122Z" fill="black" />
                </svg>
                <span class="choise-item__text"><?php esc_html_e("got redirected", "redirect-redirection"); ?></span>
            </div>
            <span><?php esc_html_e("or", "redirect-redirection"); ?></span>
            <div class="redirect-start-banner__404-item choise-item">
                <svg width="52" height="34" id="icon-404" viewBox="0 0 53 34" class="choise-item__icon">
                <rect width="52" height="34" rx="2.74648" fill="#CECEFF" />
                <path d="M0 2.74648C0 1.22964 1.22964 0 2.74648 0L49.2733 0C50.7902 0 52.0198 1.22964 52.0198 2.74648V5.89846L0 5.89846L0 2.74648Z" fill="#625DED" />
                <path fill-rule="evenodd" clip-rule="evenodd" d="M4.08516 4.09561C4.57169 4.09561 4.96609 3.7012 4.96609 3.21468C4.96609 2.72815 4.57169 2.33374 4.08516 2.33374C3.59863 2.33374 3.20422 2.72815 3.20422 3.21468C3.20422 3.7012 3.59863 4.09561 4.08516 4.09561Z" fill="#E83636" />
                <path fill-rule="evenodd" clip-rule="evenodd" d="M6.60213 4.09561C7.08865 4.09561 7.48306 3.7012 7.48306 3.21468C7.48306 2.72815 7.08865 2.33374 6.60213 2.33374C6.1156 2.33374 5.72119 2.72815 5.72119 3.21468C5.72119 3.7012 6.1156 4.09561 6.60213 4.09561Z" fill="#EE9928" />
                <path fill-rule="evenodd" clip-rule="evenodd" d="M9.11909 4.09561C9.60562 4.09561 10 3.7012 10 3.21468C10 2.72815 9.60562 2.33374 9.11909 2.33374C8.63257 2.33374 8.23816 2.72815 8.23816 3.21468C8.23816 3.7012 8.63257 4.09561 9.11909 4.09561Z" fill="#31CB13" />
                <path d="M19.24 22.354H17.188V25H14.344V22.354H7.558V20.392L13.498 12.4H16.558L11.05 19.978H14.434V17.62H17.188V19.978H19.24V22.354ZM25.5122 25.216C24.4682 25.216 23.5382 24.958 22.7222 24.442C21.9062 23.926 21.2642 23.182 20.7962 22.21C20.3402 21.226 20.1122 20.056 20.1122 18.7C20.1122 17.344 20.3402 16.18 20.7962 15.208C21.2642 14.224 21.9062 13.474 22.7222 12.958C23.5382 12.442 24.4682 12.184 25.5122 12.184C26.5562 12.184 27.4862 12.442 28.3022 12.958C29.1182 13.474 29.7542 14.224 30.2102 15.208C30.6782 16.18 30.9122 17.344 30.9122 18.7C30.9122 20.056 30.6782 21.226 30.2102 22.21C29.7542 23.182 29.1182 23.926 28.3022 24.442C27.4862 24.958 26.5562 25.216 25.5122 25.216ZM25.5122 22.75C26.2802 22.75 26.8802 22.42 27.3122 21.76C27.7562 21.1 27.9782 20.08 27.9782 18.7C27.9782 17.32 27.7562 16.3 27.3122 15.64C26.8802 14.98 26.2802 14.65 25.5122 14.65C24.7562 14.65 24.1562 14.98 23.7122 15.64C23.2802 16.3 23.0642 17.32 23.0642 18.7C23.0642 20.08 23.2802 21.1 23.7122 21.76C24.1562 22.42 24.7562 22.75 25.5122 22.75ZM43.867 22.354H41.815V25L38.971 25V22.354H32.185V20.392L38.125 12.4H41.185L35.677 19.978H39.061V17.62H41.815V19.978H43.867V22.354Z" fill="white" />
                </svg>
                <span class="choise-item__text"><?php esc_html_e("landed on a dead page (404)", "redirect-redirection"); ?></span>
            </div>
        </div>
        <div class="redirect-logs__intro note-item">
            <div class="note-item__hidden-content">
                <p class="note-item__text">
                    <?php esc_html_e("Use the logs to better understand visitor behavior on your site. Also it helps you to identify 404s so that you can apply redirects. This is recommended as 404s are neither good for user experience nor SEO.", "redirect-redirection"); ?>                    
                </p>
                <fieldset class="note-item-content">
                    <legend class="note-item-content__legend"><?php esc_html_e("Note", "redirect-redirection"); ?></legend>
                    <?php esc_html_e("As quick solution, you can redirect all your 404s to a working page in one go. To do that, go to the", "redirect-redirection"); ?>
                    <a href="!#" class="note-item-content__text-primary ir-load-tab-action" data-tab="redirection-rules"><?php esc_html_e("Redirection Rules", "redirect-redirection"); ?></a><?php esc_html_e("-tab, select the condition", "redirect-redirection"); ?>
                    <?php esc_html_e('"Are 404s" in the "Redirect all URLs which:" drop-down, and then specify where they should redirect to.', "redirect-redirection"); ?>
                </fieldset>

            </div>
            <span class="note-item__btn-open btn-open">
                <span class="note-item__title-text btn-open__text"><?php esc_html_e("Show intro", "redirect-redirection"); ?></span>
                <svg class="note-item__title-icon btn-open__icon" width="16" height="10" id="icon-arrow-down" viewBox="0 0 16 9">
                <path d="M1 1L7.94118 7L15 1" stroke="#257671" stroke-width="2" fill="none" />
                </svg>
            </span>
        </div>
    </div>
</div>
