<?php
/**
 * Your code here.
 */

// Ajouter des polices personnalisées
function add_custom_font( $fonts ) {
    $fonts['Geometria'] = 'Geometria';
    $fonts['LM Roman'] = 'LM Roman';
    return $fonts;
}
add_filter( 'presscore_options_get_safe_fonts', 'add_custom_font', 30, 1 );

// Charger les styles et scripts nécessaires
function my_child_theme_enqueue_styles() {
    // Style du thème parent
    wp_enqueue_style('parent-style', get_template_directory_uri() . '/style.css');

    // Style du widget D-Edge
    wp_enqueue_style('d-edge-widgets-css', 'https://websdk.d-edge.com/widgets/app.css', array(), null);

    // Script du widget D-Edge
    wp_enqueue_script('d-edge-widgets', 'https://websdk.d-edge.com/widgets/app.js', array(), null, true);

    // Script d'initialisation du widget
    wp_add_inline_script('d-edge-widgets', '
        document.addEventListener("DOMContentLoaded", function() {
            if (typeof FBWidget !== "undefined" && typeof FBWidget.init === "function") {
                FBWidget.init();
            } else {
                console.error("FBWidget not loaded");
            }
        });
    ');
}
add_action('wp_enqueue_scripts', 'my_child_theme_enqueue_styles');

function load_youtube_api() {
    wp_enqueue_script('youtube-api', 'https://www.youtube.com/iframe_api', array(), null, true);
}
add_action('wp_enqueue_scripts', 'load_youtube_api');