/******/ (() => { // webpackBootstrap
/******/ 	"use strict";
/******/ 	var __webpack_modules__ = ({

/***/ "./node_modules/@wordpress/hooks/build-module/createAddHook.js":
/*!*********************************************************************!*\
  !*** ./node_modules/@wordpress/hooks/build-module/createAddHook.js ***!
  \*********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _validateNamespace_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./validateNamespace.js */ "./node_modules/@wordpress/hooks/build-module/validateNamespace.js");
/* harmony import */ var _validateHookName_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./validateHookName.js */ "./node_modules/@wordpress/hooks/build-module/validateHookName.js");
/**
 * Internal dependencies
 */



/**
 * @callback AddHook
 *
 * Adds the hook to the appropriate hooks container.
 *
 * @param {string}               hookName      Name of hook to add
 * @param {string}               namespace     The unique namespace identifying the callback in the form `vendor/plugin/function`.
 * @param {import('.').Callback} callback      Function to call when the hook is run
 * @param {number}               [priority=10] Priority of this hook
 */

/**
 * Returns a function which, when invoked, will add a hook.
 *
 * @param {import('.').Hooks}    hooks    Hooks instance.
 * @param {import('.').StoreKey} storeKey
 *
 * @return {AddHook} Function that adds a new hook.
 */
function createAddHook(hooks, storeKey) {
  return function addHook(hookName, namespace, callback, priority = 10) {
    const hooksStore = hooks[storeKey];
    if (!(0,_validateHookName_js__WEBPACK_IMPORTED_MODULE_1__["default"])(hookName)) {
      return;
    }
    if (!(0,_validateNamespace_js__WEBPACK_IMPORTED_MODULE_0__["default"])(namespace)) {
      return;
    }
    if ('function' !== typeof callback) {
      // eslint-disable-next-line no-console
      console.error('The hook callback must be a function.');
      return;
    }

    // Validate numeric priority
    if ('number' !== typeof priority) {
      // eslint-disable-next-line no-console
      console.error('If specified, the hook priority must be a number.');
      return;
    }
    const handler = {
      callback,
      priority,
      namespace
    };
    if (hooksStore[hookName]) {
      // Find the correct insert index of the new hook.
      const handlers = hooksStore[hookName].handlers;

      /** @type {number} */
      let i;
      for (i = handlers.length; i > 0; i--) {
        if (priority >= handlers[i - 1].priority) {
          break;
        }
      }
      if (i === handlers.length) {
        // If append, operate via direct assignment.
        handlers[i] = handler;
      } else {
        // Otherwise, insert before index via splice.
        handlers.splice(i, 0, handler);
      }

      // We may also be currently executing this hook.  If the callback
      // we're adding would come after the current callback, there's no
      // problem; otherwise we need to increase the execution index of
      // any other runs by 1 to account for the added element.
      hooksStore.__current.forEach(hookInfo => {
        if (hookInfo.name === hookName && hookInfo.currentIndex >= i) {
          hookInfo.currentIndex++;
        }
      });
    } else {
      // This is the first hook of its type.
      hooksStore[hookName] = {
        handlers: [handler],
        runs: 0
      };
    }
    if (hookName !== 'hookAdded') {
      hooks.doAction('hookAdded', hookName, namespace, callback, priority);
    }
  };
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (createAddHook);
//# sourceMappingURL=createAddHook.js.map

/***/ }),

/***/ "./node_modules/@wordpress/hooks/build-module/createCurrentHook.js":
/*!*************************************************************************!*\
  !*** ./node_modules/@wordpress/hooks/build-module/createCurrentHook.js ***!
  \*************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/**
 * Returns a function which, when invoked, will return the name of the
 * currently running hook, or `null` if no hook of the given type is currently
 * running.
 *
 * @param {import('.').Hooks}    hooks    Hooks instance.
 * @param {import('.').StoreKey} storeKey
 *
 * @return {() => string | null} Function that returns the current hook name or null.
 */
function createCurrentHook(hooks, storeKey) {
  return function currentHook() {
    var _hooksStore$__current;
    const hooksStore = hooks[storeKey];
    return (_hooksStore$__current = hooksStore.__current[hooksStore.__current.length - 1]?.name) !== null && _hooksStore$__current !== void 0 ? _hooksStore$__current : null;
  };
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (createCurrentHook);
//# sourceMappingURL=createCurrentHook.js.map

/***/ }),

/***/ "./node_modules/@wordpress/hooks/build-module/createDidHook.js":
/*!*********************************************************************!*\
  !*** ./node_modules/@wordpress/hooks/build-module/createDidHook.js ***!
  \*********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _validateHookName_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./validateHookName.js */ "./node_modules/@wordpress/hooks/build-module/validateHookName.js");
/**
 * Internal dependencies
 */


/**
 * @callback DidHook
 *
 * Returns the number of times an action has been fired.
 *
 * @param {string} hookName The hook name to check.
 *
 * @return {number | undefined} The number of times the hook has run.
 */

/**
 * Returns a function which, when invoked, will return the number of times a
 * hook has been called.
 *
 * @param {import('.').Hooks}    hooks    Hooks instance.
 * @param {import('.').StoreKey} storeKey
 *
 * @return {DidHook} Function that returns a hook's call count.
 */
function createDidHook(hooks, storeKey) {
  return function didHook(hookName) {
    const hooksStore = hooks[storeKey];
    if (!(0,_validateHookName_js__WEBPACK_IMPORTED_MODULE_0__["default"])(hookName)) {
      return;
    }
    return hooksStore[hookName] && hooksStore[hookName].runs ? hooksStore[hookName].runs : 0;
  };
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (createDidHook);
//# sourceMappingURL=createDidHook.js.map

/***/ }),

/***/ "./node_modules/@wordpress/hooks/build-module/createDoingHook.js":
/*!***********************************************************************!*\
  !*** ./node_modules/@wordpress/hooks/build-module/createDoingHook.js ***!
  \***********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/**
 * @callback DoingHook
 * Returns whether a hook is currently being executed.
 *
 * @param {string} [hookName] The name of the hook to check for.  If
 *                            omitted, will check for any hook being executed.
 *
 * @return {boolean} Whether the hook is being executed.
 */

/**
 * Returns a function which, when invoked, will return whether a hook is
 * currently being executed.
 *
 * @param {import('.').Hooks}    hooks    Hooks instance.
 * @param {import('.').StoreKey} storeKey
 *
 * @return {DoingHook} Function that returns whether a hook is currently
 *                     being executed.
 */
function createDoingHook(hooks, storeKey) {
  return function doingHook(hookName) {
    const hooksStore = hooks[storeKey];

    // If the hookName was not passed, check for any current hook.
    if ('undefined' === typeof hookName) {
      return 'undefined' !== typeof hooksStore.__current[0];
    }

    // Return the __current hook.
    return hooksStore.__current[0] ? hookName === hooksStore.__current[0].name : false;
  };
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (createDoingHook);
//# sourceMappingURL=createDoingHook.js.map

/***/ }),

/***/ "./node_modules/@wordpress/hooks/build-module/createHasHook.js":
/*!*********************************************************************!*\
  !*** ./node_modules/@wordpress/hooks/build-module/createHasHook.js ***!
  \*********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/**
 * @callback HasHook
 *
 * Returns whether any handlers are attached for the given hookName and optional namespace.
 *
 * @param {string} hookName    The name of the hook to check for.
 * @param {string} [namespace] Optional. The unique namespace identifying the callback
 *                             in the form `vendor/plugin/function`.
 *
 * @return {boolean} Whether there are handlers that are attached to the given hook.
 */
/**
 * Returns a function which, when invoked, will return whether any handlers are
 * attached to a particular hook.
 *
 * @param {import('.').Hooks}    hooks    Hooks instance.
 * @param {import('.').StoreKey} storeKey
 *
 * @return {HasHook} Function that returns whether any handlers are
 *                   attached to a particular hook and optional namespace.
 */
function createHasHook(hooks, storeKey) {
  return function hasHook(hookName, namespace) {
    const hooksStore = hooks[storeKey];

    // Use the namespace if provided.
    if ('undefined' !== typeof namespace) {
      return hookName in hooksStore && hooksStore[hookName].handlers.some(hook => hook.namespace === namespace);
    }
    return hookName in hooksStore;
  };
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (createHasHook);
//# sourceMappingURL=createHasHook.js.map

/***/ }),

/***/ "./node_modules/@wordpress/hooks/build-module/createHooks.js":
/*!*******************************************************************!*\
  !*** ./node_modules/@wordpress/hooks/build-module/createHooks.js ***!
  \*******************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   _Hooks: () => (/* binding */ _Hooks),
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _createAddHook__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./createAddHook */ "./node_modules/@wordpress/hooks/build-module/createAddHook.js");
/* harmony import */ var _createRemoveHook__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./createRemoveHook */ "./node_modules/@wordpress/hooks/build-module/createRemoveHook.js");
/* harmony import */ var _createHasHook__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./createHasHook */ "./node_modules/@wordpress/hooks/build-module/createHasHook.js");
/* harmony import */ var _createRunHook__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./createRunHook */ "./node_modules/@wordpress/hooks/build-module/createRunHook.js");
/* harmony import */ var _createCurrentHook__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./createCurrentHook */ "./node_modules/@wordpress/hooks/build-module/createCurrentHook.js");
/* harmony import */ var _createDoingHook__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./createDoingHook */ "./node_modules/@wordpress/hooks/build-module/createDoingHook.js");
/* harmony import */ var _createDidHook__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./createDidHook */ "./node_modules/@wordpress/hooks/build-module/createDidHook.js");
/**
 * Internal dependencies
 */








/**
 * Internal class for constructing hooks. Use `createHooks()` function
 *
 * Note, it is necessary to expose this class to make its type public.
 *
 * @private
 */
class _Hooks {
  constructor() {
    /** @type {import('.').Store} actions */
    this.actions = Object.create(null);
    this.actions.__current = [];

    /** @type {import('.').Store} filters */
    this.filters = Object.create(null);
    this.filters.__current = [];
    this.addAction = (0,_createAddHook__WEBPACK_IMPORTED_MODULE_0__["default"])(this, 'actions');
    this.addFilter = (0,_createAddHook__WEBPACK_IMPORTED_MODULE_0__["default"])(this, 'filters');
    this.removeAction = (0,_createRemoveHook__WEBPACK_IMPORTED_MODULE_1__["default"])(this, 'actions');
    this.removeFilter = (0,_createRemoveHook__WEBPACK_IMPORTED_MODULE_1__["default"])(this, 'filters');
    this.hasAction = (0,_createHasHook__WEBPACK_IMPORTED_MODULE_2__["default"])(this, 'actions');
    this.hasFilter = (0,_createHasHook__WEBPACK_IMPORTED_MODULE_2__["default"])(this, 'filters');
    this.removeAllActions = (0,_createRemoveHook__WEBPACK_IMPORTED_MODULE_1__["default"])(this, 'actions', true);
    this.removeAllFilters = (0,_createRemoveHook__WEBPACK_IMPORTED_MODULE_1__["default"])(this, 'filters', true);
    this.doAction = (0,_createRunHook__WEBPACK_IMPORTED_MODULE_3__["default"])(this, 'actions');
    this.applyFilters = (0,_createRunHook__WEBPACK_IMPORTED_MODULE_3__["default"])(this, 'filters', true);
    this.currentAction = (0,_createCurrentHook__WEBPACK_IMPORTED_MODULE_4__["default"])(this, 'actions');
    this.currentFilter = (0,_createCurrentHook__WEBPACK_IMPORTED_MODULE_4__["default"])(this, 'filters');
    this.doingAction = (0,_createDoingHook__WEBPACK_IMPORTED_MODULE_5__["default"])(this, 'actions');
    this.doingFilter = (0,_createDoingHook__WEBPACK_IMPORTED_MODULE_5__["default"])(this, 'filters');
    this.didAction = (0,_createDidHook__WEBPACK_IMPORTED_MODULE_6__["default"])(this, 'actions');
    this.didFilter = (0,_createDidHook__WEBPACK_IMPORTED_MODULE_6__["default"])(this, 'filters');
  }
}

/** @typedef {_Hooks} Hooks */

/**
 * Returns an instance of the hooks object.
 *
 * @return {Hooks} A Hooks instance.
 */
function createHooks() {
  return new _Hooks();
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (createHooks);
//# sourceMappingURL=createHooks.js.map

/***/ }),

/***/ "./node_modules/@wordpress/hooks/build-module/createRemoveHook.js":
/*!************************************************************************!*\
  !*** ./node_modules/@wordpress/hooks/build-module/createRemoveHook.js ***!
  \************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _validateNamespace_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./validateNamespace.js */ "./node_modules/@wordpress/hooks/build-module/validateNamespace.js");
/* harmony import */ var _validateHookName_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./validateHookName.js */ "./node_modules/@wordpress/hooks/build-module/validateHookName.js");
/**
 * Internal dependencies
 */



/**
 * @callback RemoveHook
 * Removes the specified callback (or all callbacks) from the hook with a given hookName
 * and namespace.
 *
 * @param {string} hookName  The name of the hook to modify.
 * @param {string} namespace The unique namespace identifying the callback in the
 *                           form `vendor/plugin/function`.
 *
 * @return {number | undefined} The number of callbacks removed.
 */

/**
 * Returns a function which, when invoked, will remove a specified hook or all
 * hooks by the given name.
 *
 * @param {import('.').Hooks}    hooks             Hooks instance.
 * @param {import('.').StoreKey} storeKey
 * @param {boolean}              [removeAll=false] Whether to remove all callbacks for a hookName,
 *                                                 without regard to namespace. Used to create
 *                                                 `removeAll*` functions.
 *
 * @return {RemoveHook} Function that removes hooks.
 */
function createRemoveHook(hooks, storeKey, removeAll = false) {
  return function removeHook(hookName, namespace) {
    const hooksStore = hooks[storeKey];
    if (!(0,_validateHookName_js__WEBPACK_IMPORTED_MODULE_1__["default"])(hookName)) {
      return;
    }
    if (!removeAll && !(0,_validateNamespace_js__WEBPACK_IMPORTED_MODULE_0__["default"])(namespace)) {
      return;
    }

    // Bail if no hooks exist by this name.
    if (!hooksStore[hookName]) {
      return 0;
    }
    let handlersRemoved = 0;
    if (removeAll) {
      handlersRemoved = hooksStore[hookName].handlers.length;
      hooksStore[hookName] = {
        runs: hooksStore[hookName].runs,
        handlers: []
      };
    } else {
      // Try to find the specified callback to remove.
      const handlers = hooksStore[hookName].handlers;
      for (let i = handlers.length - 1; i >= 0; i--) {
        if (handlers[i].namespace === namespace) {
          handlers.splice(i, 1);
          handlersRemoved++;
          // This callback may also be part of a hook that is
          // currently executing.  If the callback we're removing
          // comes after the current callback, there's no problem;
          // otherwise we need to decrease the execution index of any
          // other runs by 1 to account for the removed element.
          hooksStore.__current.forEach(hookInfo => {
            if (hookInfo.name === hookName && hookInfo.currentIndex >= i) {
              hookInfo.currentIndex--;
            }
          });
        }
      }
    }
    if (hookName !== 'hookRemoved') {
      hooks.doAction('hookRemoved', hookName, namespace);
    }
    return handlersRemoved;
  };
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (createRemoveHook);
//# sourceMappingURL=createRemoveHook.js.map

/***/ }),

/***/ "./node_modules/@wordpress/hooks/build-module/createRunHook.js":
/*!*********************************************************************!*\
  !*** ./node_modules/@wordpress/hooks/build-module/createRunHook.js ***!
  \*********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/**
 * Returns a function which, when invoked, will execute all callbacks
 * registered to a hook of the specified type, optionally returning the final
 * value of the call chain.
 *
 * @param {import('.').Hooks}    hooks                  Hooks instance.
 * @param {import('.').StoreKey} storeKey
 * @param {boolean}              [returnFirstArg=false] Whether each hook callback is expected to
 *                                                      return its first argument.
 *
 * @return {(hookName:string, ...args: unknown[]) => undefined|unknown} Function that runs hook callbacks.
 */
function createRunHook(hooks, storeKey, returnFirstArg = false) {
  return function runHooks(hookName, ...args) {
    const hooksStore = hooks[storeKey];
    if (!hooksStore[hookName]) {
      hooksStore[hookName] = {
        handlers: [],
        runs: 0
      };
    }
    hooksStore[hookName].runs++;
    const handlers = hooksStore[hookName].handlers;

    // The following code is stripped from production builds.
    if (true) {
      // Handle any 'all' hooks registered.
      if ('hookAdded' !== hookName && hooksStore.all) {
        handlers.push(...hooksStore.all.handlers);
      }
    }
    if (!handlers || !handlers.length) {
      return returnFirstArg ? args[0] : undefined;
    }
    const hookInfo = {
      name: hookName,
      currentIndex: 0
    };
    hooksStore.__current.push(hookInfo);
    while (hookInfo.currentIndex < handlers.length) {
      const handler = handlers[hookInfo.currentIndex];
      const result = handler.callback.apply(null, args);
      if (returnFirstArg) {
        args[0] = result;
      }
      hookInfo.currentIndex++;
    }
    hooksStore.__current.pop();
    if (returnFirstArg) {
      return args[0];
    }
    return undefined;
  };
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (createRunHook);
//# sourceMappingURL=createRunHook.js.map

/***/ }),

/***/ "./node_modules/@wordpress/hooks/build-module/index.js":
/*!*************************************************************!*\
  !*** ./node_modules/@wordpress/hooks/build-module/index.js ***!
  \*************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   actions: () => (/* binding */ actions),
/* harmony export */   addAction: () => (/* binding */ addAction),
/* harmony export */   addFilter: () => (/* binding */ addFilter),
/* harmony export */   applyFilters: () => (/* binding */ applyFilters),
/* harmony export */   createHooks: () => (/* reexport safe */ _createHooks__WEBPACK_IMPORTED_MODULE_0__["default"]),
/* harmony export */   currentAction: () => (/* binding */ currentAction),
/* harmony export */   currentFilter: () => (/* binding */ currentFilter),
/* harmony export */   defaultHooks: () => (/* binding */ defaultHooks),
/* harmony export */   didAction: () => (/* binding */ didAction),
/* harmony export */   didFilter: () => (/* binding */ didFilter),
/* harmony export */   doAction: () => (/* binding */ doAction),
/* harmony export */   doingAction: () => (/* binding */ doingAction),
/* harmony export */   doingFilter: () => (/* binding */ doingFilter),
/* harmony export */   filters: () => (/* binding */ filters),
/* harmony export */   hasAction: () => (/* binding */ hasAction),
/* harmony export */   hasFilter: () => (/* binding */ hasFilter),
/* harmony export */   removeAction: () => (/* binding */ removeAction),
/* harmony export */   removeAllActions: () => (/* binding */ removeAllActions),
/* harmony export */   removeAllFilters: () => (/* binding */ removeAllFilters),
/* harmony export */   removeFilter: () => (/* binding */ removeFilter)
/* harmony export */ });
/* harmony import */ var _createHooks__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./createHooks */ "./node_modules/@wordpress/hooks/build-module/createHooks.js");
/**
 * Internal dependencies
 */


/** @typedef {(...args: any[])=>any} Callback */

/**
 * @typedef Handler
 * @property {Callback} callback  The callback
 * @property {string}   namespace The namespace
 * @property {number}   priority  The namespace
 */

/**
 * @typedef Hook
 * @property {Handler[]} handlers Array of handlers
 * @property {number}    runs     Run counter
 */

/**
 * @typedef Current
 * @property {string} name         Hook name
 * @property {number} currentIndex The index
 */

/**
 * @typedef {Record<string, Hook> & {__current: Current[]}} Store
 */

/**
 * @typedef {'actions' | 'filters'} StoreKey
 */

/**
 * @typedef {import('./createHooks').Hooks} Hooks
 */

const defaultHooks = (0,_createHooks__WEBPACK_IMPORTED_MODULE_0__["default"])();
const {
  addAction,
  addFilter,
  removeAction,
  removeFilter,
  hasAction,
  hasFilter,
  removeAllActions,
  removeAllFilters,
  doAction,
  applyFilters,
  currentAction,
  currentFilter,
  doingAction,
  doingFilter,
  didAction,
  didFilter,
  actions,
  filters
} = defaultHooks;

//# sourceMappingURL=index.js.map

/***/ }),

/***/ "./node_modules/@wordpress/hooks/build-module/validateHookName.js":
/*!************************************************************************!*\
  !*** ./node_modules/@wordpress/hooks/build-module/validateHookName.js ***!
  \************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/**
 * Validate a hookName string.
 *
 * @param {string} hookName The hook name to validate. Should be a non empty string containing
 *                          only numbers, letters, dashes, periods and underscores. Also,
 *                          the hook name cannot begin with `__`.
 *
 * @return {boolean} Whether the hook name is valid.
 */
function validateHookName(hookName) {
  if ('string' !== typeof hookName || '' === hookName) {
    // eslint-disable-next-line no-console
    console.error('The hook name must be a non-empty string.');
    return false;
  }
  if (/^__/.test(hookName)) {
    // eslint-disable-next-line no-console
    console.error('The hook name cannot begin with `__`.');
    return false;
  }
  if (!/^[a-zA-Z][a-zA-Z0-9_.-]*$/.test(hookName)) {
    // eslint-disable-next-line no-console
    console.error('The hook name can only contain numbers, letters, dashes, periods and underscores.');
    return false;
  }
  return true;
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (validateHookName);
//# sourceMappingURL=validateHookName.js.map

/***/ }),

/***/ "./node_modules/@wordpress/hooks/build-module/validateNamespace.js":
/*!*************************************************************************!*\
  !*** ./node_modules/@wordpress/hooks/build-module/validateNamespace.js ***!
  \*************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/**
 * Validate a namespace string.
 *
 * @param {string} namespace The namespace to validate - should take the form
 *                           `vendor/plugin/function`.
 *
 * @return {boolean} Whether the namespace is valid.
 */
function validateNamespace(namespace) {
  if ('string' !== typeof namespace || '' === namespace) {
    // eslint-disable-next-line no-console
    console.error('The namespace must be a non-empty string.');
    return false;
  }
  if (!/^[a-zA-Z][a-zA-Z0-9_.\-\/]*$/.test(namespace)) {
    // eslint-disable-next-line no-console
    console.error('The namespace can only contain numbers, letters, dashes, periods, underscores and slashes.');
    return false;
  }
  return true;
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (validateNamespace);
//# sourceMappingURL=validateNamespace.js.map

/***/ })

/******/ 	});
/************************************************************************/
/******/ 	// The module cache
/******/ 	var __webpack_module_cache__ = {};
/******/ 	
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/ 		// Check if module is in cache
/******/ 		var cachedModule = __webpack_module_cache__[moduleId];
/******/ 		if (cachedModule !== undefined) {
/******/ 			return cachedModule.exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = __webpack_module_cache__[moduleId] = {
/******/ 			// no module.id needed
/******/ 			// no module.loaded needed
/******/ 			exports: {}
/******/ 		};
/******/ 	
/******/ 		// Execute the module function
/******/ 		__webpack_modules__[moduleId](module, module.exports, __webpack_require__);
/******/ 	
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/ 	
/************************************************************************/
/******/ 	/* webpack/runtime/define property getters */
/******/ 	(() => {
/******/ 		// define getter functions for harmony exports
/******/ 		__webpack_require__.d = (exports, definition) => {
/******/ 			for(var key in definition) {
/******/ 				if(__webpack_require__.o(definition, key) && !__webpack_require__.o(exports, key)) {
/******/ 					Object.defineProperty(exports, key, { enumerable: true, get: definition[key] });
/******/ 				}
/******/ 			}
/******/ 		};
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/hasOwnProperty shorthand */
/******/ 	(() => {
/******/ 		__webpack_require__.o = (obj, prop) => (Object.prototype.hasOwnProperty.call(obj, prop))
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/make namespace object */
/******/ 	(() => {
/******/ 		// define __esModule on exports
/******/ 		__webpack_require__.r = (exports) => {
/******/ 			if(typeof Symbol !== 'undefined' && Symbol.toStringTag) {
/******/ 				Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });
/******/ 			}
/******/ 			Object.defineProperty(exports, '__esModule', { value: true });
/******/ 		};
/******/ 	})();
/******/ 	
/************************************************************************/
var __webpack_exports__ = {};
// This entry need to be wrapped in an IIFE because it need to be isolated against other modules in the chunk.
(() => {
/*!******************************!*\
  !*** ./assets/js/builder.js ***!
  \******************************/
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _wordpress_hooks__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/hooks */ "./node_modules/@wordpress/hooks/build-module/index.js");
function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
var _this = undefined;
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function _defineProperty(obj, key, value) { key = _toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }

var Builder,
  sketch = VueColor.Sketch,
  dummyLightBoxComponent = 'sby-dummy-lightbox-component';
SB_Customizer.initPromise.then(function (customizer) {
  var _objectSpread2;
  var extraMethods = _objectSpread(_objectSpread({}, customizer.extraMethods), {}, {
    updateColorValue: function updateColorValue(id) {
      var self = this;
      self.customizerFeedData.settings[id] = self.customizerFeedData.settings[id].a == 1 ? self.customizerFeedData.settings[id].hex : self.customizerFeedData.settings[id].hex8;
    },
    sw_feed_params: function sw_feed_params() {
      var sw_feed_param = '';
      if (this.sw_feed) {
        sw_feed_param += '&sw-feed=true';
      }
      if (this.sw_feed_id) {
        sw_feed_param += '&sw-feed-id=' + this.sw_feed_id;
      }
      return sw_feed_param;
    },
    swfeedReturnUrl: function swfeedReturnUrl() {
      var self = this;
      var sw_return_url = '';
      if (self.sw_feed) {
        sw_return_url = 'admin.php?page=sbsw#/create-feed';
      }
      if (self.sw_feed_id) {
        sw_return_url = 'admin.php?page=sbsw&feed_id=' + self.sw_feed_id;
      }
      return sw_return_url;
    },
    customizerStyleMaker: function customizerStyleMaker() {
      var self = this;
      if (self.customizerSidebarBuilder) {
        self.feedStyle = '';
        Object.values(self.customizerSidebarBuilder).map(function (tab) {
          self.customizerSectionStyle(tab.sections);
        });
        return '<style type="text/css">' + self.feedStyle + '</style>';
      }
      return false;
    },
    customizerSectionStyle: function customizerSectionStyle(sections) {
      var self = this;
      Object.values(sections).map(function (section) {
        if (section.controls) {
          Object.values(section.controls).map(function (control) {
            self.returnControlStyle(control);
          });
        }
        if (section.nested_sections) {
          self.customizerSectionStyle(section.nested_sections);
          Object.values(section.nested_sections).map(function (nestedSections) {
            Object.values(nestedSections.controls).map(function (nestedControl) {
              if (nestedControl.section) {
                self.customizerSectionStyle(nestedControl);
              }
            });
          });
        }
      });
    },
    returnControlStyle: function returnControlStyle(control) {
      var self = this;
      if (control.style) {
        Object.entries(control.style).map(function (css) {
          var condition = control.condition != undefined || control.checkExtension != undefined ? self.checkControlCondition(control.condition, control.checkExtension) : true;
          if (condition) {
            self.feedStyle += css[0] + '{' + css[1].replaceAll("{{value}}", self.customizerFeedData.settings[control.id]) + '}';
          }
        });
      }
    },
    /**
     * Ajax Post Action
     *
     * @since 2.0
     */
    ajaxPost: function ajaxPost(data, callback) {
      var self = this;
      data['nonce'] = this.nonce;
      self.$http.post(self.ajaxHandler, data).then(callback);
    },
    /**
     * Show & Hide View
     *
     * @since 2.0
     */
    activateView: function activateView(viewName) {
      var sourcePopupType = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 'creation';
      var ajaxAction = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : false;
      var self = this;
      self.viewsActive[viewName] = self.viewsActive[viewName] == false ? true : false;
      self.shouldShowFeedAPIForm = false;
      self.shouldShowManualConnect = false;
      self.shouldShowFeedAPIBackBtn = false;
      if (viewName == 'editName') {
        document.getElementById("sbc-csz-hd-input").focus();
      }
      if (viewName === 'feedtypesPopup') {
        self.viewsActive.feedTemplateElement = null;
        document.querySelector('body').classList.toggle('overflow-hidden');
      }
      if (viewName === 'feedtemplatesPopup') {
        self.viewsActive.feedTemplateElement = null;
        document.querySelector('body').classList.toggle('overflow-hidden');
      }
      if (viewName == 'embedPopup' && ajaxAction == true) {
        self.saveFeedSettings();
      }
      Builder.$forceUpdate();
    },
    /**
     * Switch Customizer Tab
     *
     * @sicne 2.0
     */
    switchCustomizerTab: function switchCustomizerTab(tabId) {
      var self = this,
        domBody = document.getElementsByTagName("body")[0];
      self.customizerScreens.activeTab = tabId;
      self.customizerScreens.activeSection = null;
      self.customizerScreens.activeSectionData = null;
      self.highLightedSection = 'all';
      self.dummyLightBoxScreen = false;
      domBody.classList.remove("no-overflow");
      Builder.$forceUpdate();
    },
    switchCustomizerSection: function switchCustomizerSection(sectionId, section) {
      var isNested = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : false;
      var isBackElements = arguments.length > 3 ? arguments[3] : undefined;
      var self = this;
      self.customizerScreens.parentActiveSection = null;
      self.customizerScreens.parentActiveSectionData = null;
      if (isNested) {
        self.customizerScreens.parentActiveSection = self.customizerScreens.activeSection;
        self.customizerScreens.parentActiveSectionData = self.customizerScreens.activeSectionData;
      }
      self.customizerScreens.activeSection = sectionId;
      self.customizerScreens.activeSectionData = section;
      if (!isBackElements) {
        self.enableHighLightSection(sectionId);
      }
    },
    /**
     * Ajax Action : Save Feed Settings
     *
     * @since 2.0
     */
    saveFeedSettings: function saveFeedSettings() {
      var leavePage = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : false;
      var self = this,
        sources = [],
        updateFeedData = {
          action: 'sby_feed_saver_manager_builder_update',
          update_feed: 'true',
          feed_id: self.customizerFeedData.feed_info.id,
          feed_name: self.customizerFeedData.feed_info.feed_name,
          settings: self.customizerFeedData.settings
        };
      self.loadingBar = true;
      self.ajaxPost(updateFeedData, function (_ref) {
        var data = _ref.data;
        if (data && data.success === true) {
          self.processNotification('feedSaved');
          self.customizerFeedDataInitial = self.customizerFeedData;
          if (leavePage === true) {
            setTimeout(function () {
              window.location.href = self.builderUrl;
            }, 1500);
          }
        } else {
          self.processNotification('feedSavedError');
        }
      });
      Builder.$forceUpdate();
    },
    /**
     * Activate license key from license error post grace period header notice 
     * 
     * @since 2.0.2
     */
    activateLicense: function activateLicense() {
      var self = this;
      self.licenseBtnClicked = true;
      if (self.licenseKey == null) {
        self.licenseBtnClicked = false;
        return;
      }
      var licenseData = {
        action: 'sby_license_activation',
        nonce: sbc_builder.nonce,
        license_key: self.licenseKey
      };
      self.ajaxPost(licenseData, function (_ref) {
        self.licenseBtnClicked = false;
        var data = _ref.data;
        if (data && data.success == false) {
          self.processNotification("licenseError");
          return;
        }
        if (data !== false) {
          self.processNotification("licenseActivated");
          // remove license notices
          self.viewsActive.licenseLearnMore = false;
          jQuery('#sby-license-expired-agp').slideUp();
          jQuery('#sbc-builder-app').removeClass('sbc-builder-app-lite-dismiss');
          jQuery('.sby_get_pro_highlight, .sby_get_cff, .sby_get_sbi, .sby_get_ctf').closest('li').remove();
        }
      });
    },
    /**
     * Ajax Action : Clear Single Feed Cache
     * Update Feed Preview Too
     * @since 2.0
     */
    clearSingleFeedCache: function clearSingleFeedCache() {
      var self = this,
        sources = [],
        clearFeedData = {
          action: 'sby_feed_saver_manager_clear_single_feed_cache',
          feedID: self.customizerFeedData.feed_info.id,
          feedName: self.customizerFeedData.feed_info.feed_name,
          previewSettings: self.customizerFeedData.settings
        };
      self.loadingBar = true;
      self.ajaxPost(clearFeedData, function (_ref) {
        var data = _ref.data;
        if (data !== false) {
          self.updatedTimeStamp = new Date().getTime();
          self.template = String("<div>" + data.feed_html + "</div>");
          self.processNotification('cacheCleared');
        } else {
          self.processNotification("unkownError");
        }
      });
      Builder.$forceUpdate();
    },
    //Section Checkbox
    changeCheckboxSectionValue: function changeCheckboxSectionValue(settingID, value) {
      var ajaxAction = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : false;
      var checkBoxAction = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : false;
      var self = this;
      if (checkBoxAction !== false) {
        self.customizerFeedData.settings[settingID] = self.customizerFeedData.settings[settingID] == checkBoxAction.options.enabled ? checkBoxAction.options.disabled : checkBoxAction.options.enabled;
      } else {
        var settingValue = self.customizerFeedData.settings[settingID];
        if (!Array.isArray(settingValue) && settingID == 'type') {
          settingValue = [settingValue];
        }
        if (settingValue.includes(value)) {
          settingValue.splice(settingValue.indexOf(value), 1);
        } else {
          settingValue.push(value);
        }
        if (settingID == 'type') {
          self.processFeedTypesSources(settingValue);
        }
        //settingValue = (settingValue.length == 1 && settingID == 'type') ? settingValue[0] : settingValue;
        self.customizerFeedData.settings[settingID] = settingValue;
      }
      if (ajaxAction !== false) {
        self.customizerControlAjaxAction(ajaxAction);
      }
      event.stopPropagation();
    },
    checkboxSectionValueExists: function checkboxSectionValueExists() {
      var settingID = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : 'includes';
      var value = arguments.length > 1 ? arguments[1] : undefined;
      var self = this;
      var settingValue = self.customizerFeedData.settings[settingID];
      return settingValue.includes(value) ? true : false;
    },
    /**
     * Loading Bar & Notification
     *
     * @since 2.0
     */
    processNotification: function processNotification(notificationType) {
      var self = this,
        notification = self.genericText.notification[notificationType];
      self.loadingBar = false;
      self.notificationElement = {
        type: notification.type,
        text: notification.text,
        shown: "shown"
      };
      setTimeout(function () {
        self.notificationElement.shown = "hidden";
      }, 5000);
    },
    updateInputWidth: function updateInputWidth() {
      this.customizerScreens.inputNameWidth = (document.getElementById("sbc-csz-hd-input").value.length + 6) * 8 + 'px';
    },
    /**
     * Enable Highlight Section
     *
     * @since 2.0
     */
    enableHighLightSection: function enableHighLightSection(sectionId) {
      var self = this,
        listPostSection = ['customize_feedlayout', 'customize_colorscheme', 'customize_videos', 'post_style', 'individual_elements'],
        headerSection = ['customize_header'],
        followButtonSection = ['customize_followbutton'],
        loadeMoreSection = ['customize_loadmorebutton'],
        lightBoxSection = ['customize_lightbox'],
        domBody = document.getElementsByTagName("body")[0];
      self.dummyLightBoxScreen = false;
      domBody.classList.remove("no-overflow");
      if (listPostSection.includes(sectionId)) {
        self.highLightedSection = 'postList';
        self.scrollToHighLightedSection("sbi_images");
      } else if (headerSection.includes(sectionId)) {
        self.highLightedSection = 'header';
        self.scrollToHighLightedSection("sb_instagram_header");
      } else if (followButtonSection.includes(sectionId)) {
        self.highLightedSection = 'followButton';
        self.scrollToHighLightedSection("sbi_load");
      } else if (loadeMoreSection.includes(sectionId)) {
        self.highLightedSection = 'loadMore';
        self.scrollToHighLightedSection("sbi_load");
      } else if (lightBoxSection.includes(sectionId)) {
        self.highLightedSection = 'lightBox';
        self.dummyLightBoxScreen = true;
        document.body.scrollTop = 0;
        document.documentElement.scrollTop = 0;
        domBody.classList.add("no-overflow");
      } else {
        self.highLightedSection = 'all';
        self.dummyLightBoxScreen = false;
        domBody.classList.remove("no-overflow");
      }
    },
    /**
     * Scroll to Highlighted Section
     *
     * @since 2.0
     */
    scrollToHighLightedSection: function scrollToHighLightedSection(sectionId) {
      var element = document.getElementById(sectionId) !== undefined && document.getElementById(sectionId) !== null ? document.getElementById(sectionId) : document.getElementsByClassName(sectionId)[0] !== undefined && document.getElementsByClassName(sectionId)[0] !== null ? document.getElementsByClassName(sectionId)[0] : null;
      if (element != undefined && element != null) {
        var y = element.getBoundingClientRect().top - 120 + window.pageYOffset - 10;
        window.scrollTo({
          top: y,
          behavior: 'smooth'
        });
      }
    },
    ctaToggleFeatures: function ctaToggleFeatures() {
      var self = this;
      self.freeCtaShowFeatures = !self.freeCtaShowFeatures;
      Builder.$forceUpdate();
    },
    /**
     * Show Control
     *
     * @since 2.0
     */
    isControlShown: function isControlShown(control) {
      var self = this;
      if (control.checkViewDisabled != undefined) {
        return !self.viewsActive[control.checkViewDisabled];
      }
      if (control.checkView != undefined) {
        return !self.viewsActive[control.checkView];
      }
      if (control.checkExtension != undefined && control.checkExtension != false && !self.checkExtensionActive(control.checkExtension)) {
        return self.checkExtensionActive(control.checkExtension);
      }
      if (control.conditionDimmed != undefined && self.checkControlCondition(control.conditionDimmed)) return self.checkControlCondition(control.conditionDimmed);
      if (control.overrideColorCondition != undefined) {
        return self.checkControlOverrideColor(control.overrideColorCondition);
      }
      return control.conditionHide != undefined && control.condition != undefined || control.checkExtension != undefined ? self.checkControlCondition(control.condition, control.checkExtension) : true;
    },
    /**
     * Check Color Override Condition
     *
     * @since 2.0
     */
    checkControlOverrideColor: function checkControlOverrideColor() {
      var overrideConditionsArray = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : [];
      var self = this,
        isConditionTrue = 0;
      overrideConditionsArray.map(function (condition, index) {
        if (self.checkNotEmpty(self.customizerFeedData.settings[condition]) && self.customizerFeedData.settings[condition].replace(/ /gi, '') != '#') {
          isConditionTrue += 1;
        }
      });
      return isConditionTrue >= 1 ? true : false;
    },
    switchNestedSection: function switchNestedSection(sectionId, section) {
      var self = this;
      if (section !== null) {
        self.customizerScreens.activeSection = sectionId;
        self.customizerScreens.activeSectionData = section;
      } else {
        var sectionArray = sectionId['sections'];
        var elementSectionData = self.customizerSidebarBuilder;
        sectionArray.map(function (elm, index) {
          elementSectionData = elementSectionData[elm] != undefined && elementSectionData[elm] != null ? elementSectionData[elm] : null;
        });
        if (elementSectionData != null) {
          self.customizerScreens.activeSection = sectionId['id'];
          self.customizerScreens.activeSectionData = elementSectionData;
        }
      }
      Builder.$forceUpdate();
    },
    /**
     * Check Control Condition
     *
     * @since 2.0
     */
    checkControlCondition: function checkControlCondition() {
      var conditionsArray = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : [];
      var checkExtensionActive = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;
      var checkExtensionActiveDimmed = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : false;
      var self = this,
        isConditionTrue = 0;
      Object.keys(conditionsArray).forEach(function (condition, index) {
        if (conditionsArray[condition].indexOf(self.customizerFeedData.settings[condition]) !== -1) isConditionTrue += 1;
      });
      var extensionCondition = checkExtensionActive != undefined && checkExtensionActive != false ? self.checkExtensionActive(checkExtensionActive) : true,
        extensionCondition = checkExtensionActiveDimmed != undefined && checkExtensionActiveDimmed != false && !self.checkExtensionActive(checkExtensionActiveDimmed) ? false : extensionCondition;
      return isConditionTrue == Object.keys(conditionsArray).length ? extensionCondition : false;
    },
    //Change Switcher Settings
    changeSwitcherSettingValue: function changeSwitcherSettingValue(settingID, onValue, offValue) {
      var ajaxAction = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : false;
      var self = this;
      self.customizerFeedData.settings[settingID] = self.customizerFeedData.settings[settingID] == onValue ? offValue : onValue;
      if (ajaxAction !== false) {
        self.customizerControlAjaxAction(ajaxAction);
      }
      self.regenerateLayout(settingID);
    },
    selectedFeedTypeCustomizer: function selectedFeedTypeCustomizer(feedtype) {
      var self = this,
        result = false;
      if (self.customizerFeedData.settings.type === feedtype) {
        result = true;
      }
      return result;
    },
    selectedFeedTemplateCustomizer: function selectedFeedTemplateCustomizer(feedtemplate) {
      var self = this,
        result = false;
      var self = this,
        result = false;
      if (self.viewsActive.feedTemplateElement === null && self.customizerFeedData.settings.feedtemplate === feedtemplate || self.viewsActive.feedTemplateElement !== null && self.viewsActive.feedTemplateElement == feedtemplate) {
        result = true;
      }
      return result;
    },
    chooseCustomizerFeedType: function chooseCustomizerFeedType(feedType) {
      var self = this;
      self.selectedFeed = feedType.type;
      var ifFeedAvailable = self.hasFeature(self.selectedFeed + '_feeds');
      if (self.selectedFeed != 'channel' && !self.apiKeyStatus && self.selectedFeed !== 'social_wall') {
        self.viewsActive.feedtypesPopup = false;
        self.activateView('accountAPIPopup');
        self.shouldShowFeedAPIForm = true;
        return;
      }
      if (self.selectedFeed === 'social_wall') {
        if (self.socialWallActivated) {
          window.location.href = self.socialWallAdminPage;
          return;
        }
        self.activateView('feedtypesPopup');
        self.viewsActive.extensionsPopupElement = 'social_wall';
      } else {
        if (!ifFeedAvailable) {
          self.viewsActive.extensionsPopupElement = self.selectedFeed;
        } else {
          self.customizerFeedData.settings.type = feedType.type;
        }
      }
      Builder.$forceUpdate();
    },
    chooseFeedTemplate: function chooseFeedTemplate(feedTemplate) {
      var iscustomizerPopup = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;
      var self = this;
      self.selectedFeedTemplate = feedTemplate.type;
      if (iscustomizerPopup) {
        if (!self.sbyIsPro || self.sbyLicenseNoticeActive || self.sbyLicenseInactiveState || !self.hasFeature('feeds_templates')) {
          self.activateView('feedtemplatesPopup');
          self.viewsActive.extensionsPopupElement = 'feedTemplate';
        } else {
          self.viewsActive.feedTemplateElement = feedTemplate.type;
        }
      }
      Builder.$forceUpdate();
    },
    customizerFeedTypePrint: function customizerFeedTypePrint() {
      var self = this;
      // Support for versions before v4.2
      if (self.customizerFeedData.settings.type == undefined) {
        self.customizerFeedData.settings.type = 'default';
      }
      var result = self.feedTypes.filter(function (tp) {
        return tp.type === self.customizerFeedData.settings.type;
      });
      self.customizerScreens.printedTemplate = result.length > 0 ? result[0] : [];
      return result.length > 0 ? true : false;
    },
    customizerFeedTemplatePrint: function customizerFeedTemplatePrint() {
      var self = this;
      // Support for versions before v4.2
      if (self.customizerFeedData.settings.feedtemplate == undefined) {
        self.customizerFeedData.settings.feedtemplate = 'default';
      }
      var result = self.feedTemplates.filter(function (tp) {
        return tp.type === self.customizerFeedData.settings.feedtemplate;
      });
      self.customizerScreens.printedTemplate = result.length > 0 ? result[0] : [];
      return result.length > 0 ? true : false;
    },
    updateFeedTemplateCustomizer: function updateFeedTemplateCustomizer() {
      var self = this;
      self.customizerFeedData.settings.feedtemplate = self.viewsActive.feedTemplateElement != null ? self.viewsActive.feedTemplateElement : self.customizerFeedData.settings.feedtemplate;
      self.viewsActive.feedTemplateElement = null;
      self.viewsActive.feedtemplatesPopup = false;
      self.customizerControlAjaxAction('feedTemplateFlyPreview');
      Builder.$forceUpdate();
    },
    updateFeedTypeCustomizer: function updateFeedTypeCustomizer() {
      var self = this;
      self.viewsActive.feedtypesPopup = false;
      self.customizerControlAjaxAction('feedTypeFlyPreview');
      Builder.$forceUpdate();
    },
    /**
     * Check if Data Setting is Enabled
     *
     * @since 2.0
     *
     * @return boolean
     */
    valueIsEnabled: function valueIsEnabled(value) {
      return value == 1 || value == true || value == 'true' || value == 'on';
    },
    /**
     * Check if Value is Empty
     *
     * @since 2.0
     *
     * @return boolean
     */
    checkNotEmpty: function checkNotEmpty(value) {
      return value != null && value.replace(/ /gi, '') != '';
    },
    /**
     * Hide Color Picker
     *
     * @since 4.0
     */
    hideColorPickerPospup: function hideColorPickerPospup() {
      this.customizerScreens.activeColorPicker = null;
    },
    switchScreen: function switchScreen(screenType, screenName) {
      this.viewsActive[screenType] = screenName;
      Builder.$forceUpdate();
    },
    /**
     * Parse JSON
     *
     * @since 4.0
     *
     * @return jsonObject / Boolean
     */
    jsonParse: function jsonParse(jsonString) {
      try {
        return JSON.parse(jsonString);
      } catch (e) {
        return false;
      }
    },
    /**
     * Creation process check action
     *
     * @since 2.0
     */
    creationProcessCheckAction: function creationProcessCheckAction() {
      var self = this,
        checkBtnNext = false;
      switch (self.viewsActive.selectedFeedSection) {
        case 'feedsType':
          checkBtnNext = self.selectedFeed != null ? true : false;
          window.ctfSelectedFeed = self.selectedFeed;
          break;
        case 'selectSource':
          checkBtnNext = self.creationProcessCheckAppCredentials();
          break;
        case 'selectTemplate':
          checkBtnNext = self.creationProcessCheckAppCredentials();
          break;
        case 'feedsTypeGetProcess':
          break;
      }
      return checkBtnNext;
    },
    /**
     * Back to elements
     *
     * @since 2.0
     */
    backToPostElements: function backToPostElements() {
      var self = this,
        individual_elements = self.customizerSidebarBuilder['customize'].sections.customize_videos.nested_sections.individual_elements;
      self.customizerScreens.activeSection = 'customize_videos';
      self.customizerScreens.activeSectionData = self.customizerSidebarBuilder['customize'].sections.customize_videos;
      self.switchCustomizerSection('individual_elements', individual_elements, true, true);
      Builder.$forceUpdate();
    },
    /**
     * Back to elements
     *
     * @since 2.0
     */
    backToLightboxExperience: function backToLightboxExperience() {
      var self = this,
        lightbox_experience = self.customizerSidebarBuilder['customize'].sections.customize_videos.nested_sections.customize_lightbox;
      self.customizerScreens.activeSection = 'customize_lightbox';
      self.customizerScreens.activeSectionData = self.customizerSidebarBuilder['customize'].sections.customize_videos;
      self.switchCustomizerSection('customize_lightbox', lightbox_experience, true, true);
      Builder.$forceUpdate();
    },
    /**
     * Creation process next
     *
     * @since 2.0
     */
    creationProcessNext: function creationProcessNext() {
      var self = this;
      switch (self.viewsActive.selectedFeedSection) {
        case 'feedsType':
          // if feed type is channel
          if (self.selectedFeed === 'channel') {
            if (self.connectedAccountStatus || self.apiKeyStatus) {
              self.switchScreen('selectedFeedSection', 'selectSource');
            }
            if (!self.connectedAccountStatus && !self.apiKeyStatus) {
              self.activateView('accountAPIPopup');
            }
            return;
          }

          // if feed type is not channel
          if (self.selectedFeed !== 'channel' && !self.apiKeyStatus) {
            self.activateView('accountAPIPopup');
            self.shouldShowFeedAPIForm = true;
            return;
          }
          if (self.selectedFeed !== null) {
            self.switchScreen('selectedFeedSection', 'selectSource');
          }
          break;
        case 'selectSource':
          var selectedFeedTypeSource = self.selectedFeedModel[self.selectedFeed];
          if (selectedFeedTypeSource) {
            if (self.sbyLicenseNoticeActive || !self.hasFeature('feeds_templates')) {
              self.isCreateProcessGood = true;
            } else {
              var sourceVerified = self.verifySource();
              if (sourceVerified) {
                self.switchScreen('selectedFeedSection', 'selectTemplate');
              } else {
                jQuery('.sbc-select-source-content ul').removeClass('highlight-rules').addClass('highlight-rules');
              }
            }
          }
          break;
        case 'selectTemplate':
          self.isCreateProcessGood = true;
          break;
        case 'feedsTypeGetProcess':
          break;
      }
      if (self.isCreateProcessGood) self.submitNewFeed();
    },
    verifySource: function verifySource() {
      var self = this;
      var feedType = self.selectedFeed;
      var sourceURL = self.selectedFeedModel[self.selectedFeed];
      var sourceVerified = true;
      var regex = /youtube\.com\/(channel|user|playlist|watch)/;
      if (regex.test(sourceURL)) {
        sourceVerified = false;
      }
      return sourceVerified;
    },
    /**
     * Copy text to clipboard
     *
     * @since 2.0
     */
    copyToClipBoard: function copyToClipBoard(value) {
      var self = this;
      var el = document.createElement('textarea');
      el.className = 'ctf-fb-cp-clpboard';
      el.value = value;
      document.body.appendChild(el);
      el.select();
      document.execCommand('copy');
      document.body.removeChild(el);
      self.notificationElement = {
        type: 'success',
        text: this.genericText.copiedClipboard,
        shown: "shown"
      };
      setTimeout(function () {
        self.notificationElement.shown = "hidden";
      }, 3000);
      Builder.$forceUpdate();
    },
    /**
     * Duplicate Feed
     *
     * @since 2.0
     */
    feedActionDuplicate: function feedActionDuplicate(feed) {
      var self = this,
        feedsDuplicateData = {
          action: 'sby_feed_saver_manager_duplicate_feed',
          feed_id: feed.id
        };
      self.ajaxPost(feedsDuplicateData, function (_ref) {
        var data = _ref.data;
        self.feedsList = Object.values(Object.assign({}, data));
        //self.feedsList = data;
      });
      Builder.$forceUpdate();
    },
    /**
     * Select Single Feed in List
     *
     * @since 2.0
     */
    selectFeedCheckBox: function selectFeedCheckBox(feedID) {
      if (this.feedsSelected.includes(feedID)) {
        this.feedsSelected.splice(this.feedsSelected.indexOf(feedID), 1);
      } else {
        this.feedsSelected.push(feedID);
      }
      Builder.$forceUpdate();
    },
    /**
     * Select All Feeds in List
     *
     * @since 2.0
     */
    selectAllFeedCheckBox: function selectAllFeedCheckBox() {
      var self = this;
      if (!self.checkAllFeedsActive()) {
        self.feedsSelected = [];
        self.feedsList.forEach(function (feed) {
          self.feedsSelected.push(feed.id);
        });
      } else {
        self.feedsSelected = [];
      }
    },
    /**
     * Check if All Feeds are Selected
     *
     * @since 2.0
     */
    checkAllFeedsActive: function checkAllFeedsActive() {
      var self = this,
        result = true;
      self.feedsList.forEach(function (feed) {
        if (!self.feedsSelected.includes(feed.id)) {
          result = false;
        }
      });
      return result;
    },
    /**
     * Switch Bulk Action
     *
     * @since 2.0
     */
    bulkActionClick: function bulkActionClick() {
      var self = this;
      switch (self.selectedBulkAction) {
        case 'delete':
          if (self.feedsSelected.length > 0) {
            self.openDialogBox('deleteMultipleFeeds');
          }
          break;
      }
      Builder.$forceUpdate();
    },
    switchCustomizerPreviewDevice: function switchCustomizerPreviewDevice(previewScreen) {
      var self = this;
      self.customizerScreens.previewScreen = previewScreen;
      self.loadingBar = true;
      setTimeout(function () {
        self.setShortcodeGlobalSettings(true);
        self.loadingBar = false;
      }, 200);
      Builder.$forceUpdate();
    },
    /**
     * Reset color from the customizer color picker
     *
     * @since 2.0
     */
    resetColor: function resetColor(controlId) {
      this.customizerFeedData.settings[controlId] = '';
    },
    /**
     * Show Tooltip on Hover
     *
     * @since 2.0
     */
    toggleElementTooltip: function toggleElementTooltip(tooltipText, type) {
      var align = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : 'center';
      var self = this,
        target = window.event.currentTarget,
        tooltip = target != undefined && target != null ? document.querySelector('.sb-control-elem-tltp-content') : null;
      if (tooltip != null && type == 'show') {
        self.tooltip.text = tooltipText;
        var position = target.getBoundingClientRect(),
          left = position.left + 10,
          top = position.top - 10;
        tooltip.style.left = left + 'px';
        tooltip.style.top = top + 'px';
        tooltip.style.textAlign = align;
        self.tooltip.hover = true;
      }
      if (type == 'hide') {
        setTimeout(function () {
          if (self.tooltip.hoverType != 'inside') {
            self.tooltip.hover = false;
          }
        }, 200);
      }
    },
    /**
     * Hover Tooltip
     *
     * @since 2.0
     */
    hoverTooltip: function hoverTooltip(type, hoverType) {
      this.tooltip.hover = type;
      this.tooltip.hoverType = hoverType;
    },
    reCheckLicenseKey: function reCheckLicenseKey() {
      var _this2 = this;
      var self = this;
      var licenseNoticeWrapper = document.querySelector('.sb-license-notice');
      this.recheckLicenseStatus = 'loading';
      var data = new FormData();
      data.append('action', 'sby_recheck_connection');
      data.append('license_key', self.licenseKey);
      data.append('nonce', self.nonce);
      fetch(this.ajaxHandler, {
        method: "POST",
        credentials: 'same-origin',
        body: data
      }).then(function (response) {
        return response.json();
      }).then(function (data) {
        if (data.success == true) {
          if (data.data.license == 'valid') {
            _this2.recheckLicenseStatus = 'success';
          }
          if (data.data.license != 'valid') {
            _this2.recheckLicenseStatus = 'error';
          }
          // if the api license status has changed from old stored license status
          // then reload the page to show proper error message and notices
          // or hide error messages and notices

          setTimeout(function () {
            this.recheckLicenseStatus = null;
            if (data.data.license == 'valid') {
              licenseNoticeWrapper.remove();
            }
          }.bind(_this2), 3000);
        }
        return;
      });
    },
    recheckBtnText: function recheckBtnText(btnName) {
      var self = this;
      if (self.recheckLicenseStatus == null) {
        return self.genericText.recheckLicenseKey;
      } else if (self.recheckLicenseStatus == 'loading') {
        return self.svgIcons['loader'];
      } else if (self.recheckLicenseStatus == 'success') {
        return self.svgIcons.checkmarkCircleSVG + ' ' + self.genericText.licenseValid;
      } else if (self.recheckLicenseStatus == 'error') {
        return self.svgIcons.timesSVG + self.genericText.licenseExpired;
      }
    },
    /**
     * Back Click in the Creation Process
     *
     * @since 2.0
     */
    creationProcessBack: function creationProcessBack() {
      var self = this;
      switch (self.viewsActive.selectedFeedSection) {
        case 'feedsType':
          self.switchScreen('pageScreen', 'welcome');
          break;
        case 'selectSource':
          self.switchScreen('selectedFeedSection', 'feedsType');
          break;
        case 'selectTemplate':
          self.switchScreen('selectedFeedSection', 'selectSource');
          break;
        case 'feedsTypeGetProcess':
          self.switchScreen('selectedFeedSection', 'selectSource');
          break;
      }
      Builder.$forceUpdate();
    },
    /**
     * Feed List Pagination
     *
     * @since 2.0
     */
    feedListPagination: function feedListPagination(type) {
      var self = this,
        currentPage = self.feedPagination.currentPage,
        pagesNumber = self.feedPagination.pagesNumber;
      self.loadingBar = true;
      if (currentPage != 1 && type == 'prev' || currentPage < pagesNumber && type == 'next') {
        self.feedPagination.currentPage = type == 'next' ? currentPage < pagesNumber ? parseInt(currentPage) + 1 : pagesNumber : currentPage > 1 ? parseInt(currentPage) - 1 : 1;
        var postData = {
          action: 'sby_feed_saver_manager_get_feed_list_page',
          page: self.feedPagination.currentPage
        };
        self.ajaxPost(postData, function (_ref) {
          var data = _ref.data;
          if (data) {
            self.feedsList = data;
          }
          self.loadingBar = false;
        });
        Builder.$forceUpdate();
      }
    },
    /**
     * Choose Feed Type
     *
     * @since 2.0
     */
    chooseFeedType: function chooseFeedType(feedTypeEl) {
      var iscustomizerPopup = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;
      var self = this;
      self.selectedFeed = feedTypeEl.type;
      var ifFeedAvailable = self.hasFeature(self.selectedFeed + '_feeds');
      if (self.selectedFeed === 'social_wall') {
        if (self.socialWallActivated) {
          window.location.href = self.socialWallAdminPage;
          return;
        }
        self.selectedFeed = null;
        self.viewsActive.extensionsPopupElement = 'social_wall';
      } else {
        if (!ifFeedAvailable) {
          self.viewsActive.extensionsPopupElement = self.selectedFeed;
          self.selectedFeed = null;
        }
      }
      Builder.$forceUpdate();
    },
    activateProExtPopup: function activateProExtPopup(feedType) {
      var self = this;
      self.viewsActive.extensionsPopupElement = feedType.type;
    },
    /**
     * Activate API Form
     * 
     * @since 2.0
     */
    activateAPIForm: function activateAPIForm() {
      var self = this;
      self.viewsActive.accountAPIPopup = true;
      self.shouldShowFeedAPIForm = true;
    },
    /**
     * Close Onboarding Process
     *
     * @since 2.0
     */
    onboardingClose: function onboardingClose() {
      var self = this,
        wasActive = self.viewsActive.onboardingPopup ? 'newuser' : 'customizer';
      document.getElementById("sbc-builder-app").classList.remove('sb-onboarding-active');
      self.viewsActive.onboardingPopup = false;
      self.viewsActive.onboardingCustomizerPopup = false;
      self.customizerScreens.activeTab = 'customize';
      self.viewsActive.onboardingStep = 0;
      var postData = {
        action: 'sby_dismiss_onboarding',
        was_active: wasActive
      };
      self.ajaxPost(postData, function (_ref) {
        var data = _ref.data;
      });
      Builder.$forceUpdate();
    },
    /**
     * Onboarding Process Next
     *
     * @since 2.0
     */
    onboardingNext: function onboardingNext() {
      this.viewsActive.onboardingStep++;
      this.onboardingHideShow();
      Builder.$forceUpdate();
    },
    /**
     * Onboarding Process Prev
     *
     * @since 2.0
     */
    onboardingPrev: function onboardingPrev() {
      this.viewsActive.onboardingStep--;
      this.onboardingHideShow();
      Builder.$forceUpdate();
    },
    /**
     * Onboarding hide and show
     *
     * @since 2.0
     */
    onboardingHideShow: function onboardingHideShow() {
      var tooltips = document.querySelectorAll(".sb-onboarding-tooltip");
      for (var i = 0; i < tooltips.length; i++) {
        tooltips[i].style.display = "none";
      }
      document.querySelectorAll(".sb-onboarding-tooltip-" + this.viewsActive.onboardingStep)[0].style.display = "block";
      if (this.viewsActive.onboardingCustomizerPopup) {
        if (this.viewsActive.onboardingStep === 2) {
          this.switchCustomizerTab('customize');
        } else if (this.viewsActive.onboardingStep === 3) {
          this.switchCustomizerTab('settings');
        }
      }
    },
    /**
     * Position onboarding
     *
     * @since 2.0
     */
    positionOnboarding: function positionOnboarding() {
      var self = this,
        onboardingElem = document.querySelectorAll(".sb-onboarding-overlay")[0],
        wrapElem = document.getElementById("sbc-builder-app");
      if (onboardingElem === null || typeof onboardingElem === 'undefined') {
        return;
      }
      if (self.viewsActive.onboardingCustomizerPopup && self.iscustomizerScreen && self.customizerFeedData) {
        if (document.getElementById("sb-onboarding-tooltip-customizer-1") !== null) {
          wrapElem.classList.add('sb-onboarding-active');
          var step1El = document.querySelectorAll(".sbc-yt-header")[0];
          step1El.appendChild(document.getElementById("sb-onboarding-tooltip-customizer-1"));
          var step2El = document.querySelectorAll(".sb-customizer-sidebar-sec1")[0];
          step2El.appendChild(document.getElementById("sb-onboarding-tooltip-customizer-2"));
          var step3El = document.querySelectorAll(".sb-customizer-sidebar-sec1")[0];
          step3El.appendChild(document.getElementById("sb-onboarding-tooltip-customizer-3"));
          self.onboardingHideShow();
        }
      } else if (self.viewsActive.onboardingPopup && !self.iscustomizerScreen) {
        if (sbc_builder.allFeedsScreen.onboarding.type === 'single') {
          if (document.getElementById("sb-onboarding-tooltip-single-1") !== null) {
            wrapElem.classList.add('sb-onboarding-active');
            var step1El = document.querySelectorAll(".ctf-fb-wlcm-header .sb-positioning-wrap")[0];
            step1El.appendChild(document.getElementById("sb-onboarding-tooltip-single-1"));
            var step2El = document.querySelectorAll(".ctf-table-wrap")[0];
            step2El.appendChild(document.getElementById("sb-onboarding-tooltip-single-2"));
            self.onboardingHideShow();
          }
        } else {
          if (document.getElementById("sb-onboarding-tooltip-multiple-1") !== null) {
            wrapElem.classList.add('sb-onboarding-active');
            var step1El = document.querySelectorAll(".ctf-fb-wlcm-header .sb-positioning-wrap")[0];
            step1El.appendChild(document.getElementById("sb-onboarding-tooltip-multiple-1"));
            var step2El = document.querySelectorAll(".ctf-fb-lgc-ctn")[0];
            step2El.appendChild(document.getElementById("sb-onboarding-tooltip-multiple-2"));
            var step3El = document.querySelectorAll(".ctf-legacy-table-wrap")[0];
            step3El.appendChild(document.getElementById("sb-onboarding-tooltip-multiple-3"));
            self.activateView('legacyFeedsShown');
            self.onboardingHideShow();
          }
        }
      }
    },
    /**
     * Customizer Control Ajax
     * Some of the customizer controls need to perform Ajax
     * Calls in order to update the preview
     *
     * @since 2.0
     */
    customizerControlAjaxAction: function customizerControlAjaxAction(actionType) {
      var settingID = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;
      var self = this;
      switch (actionType) {
        case 'feedFlyPreview':
          self.loadingBar = true;
          self.templateRender = false;
          var previewFeedData = {
            action: 'sby_feed_saver_manager_fly_preview',
            feedID: self.customizerFeedData.feed_info.id,
            previewSettings: self.customizerFeedData.settings,
            feedName: self.customizerFeedData.feed_info.feed_name
          };
          self.ajaxPost(previewFeedData, function (_ref) {
            var data = _ref.data;
            if (data !== false) {
              self.updatedTimeStamp = new Date().getTime();
              self.template = String("<div>" + data.feed_html + "</div>");
              // document.querySelector('body').classList.toggle('overflow-hidden');
              self.setShortcodeGlobalSettings(true);
              self.processNotification("previewUpdated");
            } else {
              self.processNotification("unkownError");
            }
          });
          break;
        case 'feedTypeFlyPreview':
          self.loadingBar = true;
          self.templateRender = false;
          var previewFeedData = {
            action: 'sby_feed_saver_manager_fly_preview',
            feedID: self.customizerFeedData.feed_info.id,
            previewSettings: self.customizerFeedData.settings,
            feedName: self.customizerFeedData.feed_info.feed_name,
            isFeedTypesPopup: true
          };
          self.ajaxPost(previewFeedData, function (_ref) {
            var data = _ref.data;
            if (data !== false) {
              self.customizerFeedData.settings = data.customizerDataSettings;
              self.updatedTimeStamp = new Date().getTime();
              self.template = String("<div>" + data.feed_html + "</div>");
              document.querySelector('body').classList.toggle('overflow-hidden');
              self.processNotification("previewUpdated");
              self.loadingBar = false;
              setTimeout(function () {
                self.setShortcodeGlobalSettings(true);
              }, 500);
            } else {
              self.processNotification("unkownError");
            }
          });
          break;
        case 'feedTemplateFlyPreview':
          self.loadingBar = true;
          self.templateRender = false;
          var previewFeedData = {
            action: 'sby_feed_saver_manager_fly_preview',
            feedID: self.customizerFeedData.feed_info.id,
            previewSettings: self.customizerFeedData.settings,
            feedName: self.customizerFeedData.feed_info.feed_name,
            isFeedTemplatesPopup: true
          };
          self.ajaxPost(previewFeedData, function (_ref) {
            var data = _ref.data;
            if (data !== false) {
              self.customizerFeedData.settings = data.customizerDataSettings;
              self.updatedTimeStamp = new Date().getTime();
              self.template = String("<div>" + data.feed_html + "</div>");
              self.processNotification("previewUpdated");
              document.querySelector('body').classList.toggle('overflow-hidden');
              self.loadingBar = false;
              setTimeout(function () {
                self.setShortcodeGlobalSettings(true);
              }, 500);
            } else {
              self.processNotification("unkownError");
            }
          });
          break;
        case 'feedRefresh':
          self.loadingBar = true;
          self.templateRender = false;
          var previewFeedData = {
            action: 'sby_feed_refresh',
            feedID: self.customizerFeedData.feed_info.id,
            previewSettings: self.customizerFeedData.settings,
            feedName: self.customizerFeedData.feed_info.feed_name
          };
          self.ajaxPost(previewFeedData, function (_ref) {
            var data = _ref.data;
            if (data !== false) {
              self.customizerFeedData.settings = data.customizerDataSettings;
              self.updatedTimeStamp = new Date().getTime();
              self.template = String("<div>" + data.feed_html + "</div>");
              setTimeout(function () {
                self.setShortcodeGlobalSettings(true);
                self.loadingBar = false;
              }, 200);
              self.processNotification("previewUpdated");
              self.loadingBar = false;
            } else {
              self.processNotification("unkownError");
            }
          });
          break;
        case 'filtersAndModeration':
          self.loadingBar = true;
          self.templateRender = false;
          var previewFeedData = {
            action: 'sby_feed_saver_manager_fly_preview',
            feedID: self.customizerFeedData.feed_info.id,
            previewSettings: self.customizerFeedData.settings,
            feedName: self.customizerFeedData.feed_info.feed_name,
            clearCache: true
          };
          self.ajaxPost(previewFeedData, function (_ref) {
            var data = _ref.data;
            if (data !== false) {
              self.updatedTimeStamp = new Date().getTime();
              self.template = String("<div>" + data.feed_html + "</div>");
              // document.querySelector('body').classList.toggle('overflow-hidden');
              self.setShortcodeGlobalSettings(true);
              self.processNotification("previewUpdated");
            } else {
              self.processNotification("unkownError");
            }
          });
          break;
        case 'feedPreviewRender':
          setTimeout(function () {}, 150);
          break;
        case 'feedHandleFlyPreview':
          self.loadingBar = true;
          self.templateRender = false;
          var previewFeedData = {
            action: 'sby_feed_handle_saver_manager_fly_preview',
            feedID: self.customizerFeedData.feed_info.id,
            previewSettings: self.customizerFeedData.settings,
            feedName: self.customizerFeedData.feed_info.feed_name,
            feedType: self.customizerFeedData.settings.type
          };
          self.ajaxPost(previewFeedData, function (_ref) {
            var data = _ref.data;
            if (data !== false) {
              self.updatedTimeStamp = new Date().getTime();
              self.template = String("<div>" + data.feed_html + "</div>");
              self.setShortcodeGlobalSettings(true);
              self.customizerFeedData.settings = data.customizerDataSettings;
              self.processNotification("previewUpdated");
            } else {
              self.processNotification("unkownError");
            }
          });
          break;
      }
    },
    /**
     * Clear & Reset Color Override
     *
     * @since 4.0
    */
    resetColorOverride: function resetColorOverride(settingID) {
      this.customizerFeedData.settings[settingID] = '';
    },
    /**
     * View Feed Instances
     *
     * @since 4.0
     */
    viewFeedInstances: function viewFeedInstances(feed) {
      var self = this;
      self.viewsActive.instanceFeedActive = feed;
      self.movePopUp();
      Builder.$forceUpdate();
    },
    processDomList: function processDomList(selector, attributes) {
      document.querySelectorAll(selector).forEach(function (element) {
        attributes.map(function (attrName) {
          element.setAttribute(attrName[0], attrName[1]);
        });
      });
    },
    openTooltipBig: function openTooltipBig() {
      var self = this,
        elem = window.event.currentTarget;
      self.processDomList('.sbc-fb-onbrd-tltp-elem', [['data-active', 'false']]);
      elem.querySelector('.sbc-fb-onbrd-tltp-elem').setAttribute('data-active', 'true');
      Builder.$forceUpdate();
    },
    closeTooltipBig: function closeTooltipBig() {
      var self = this;
      self.processDomList('.sbc-fb-onbrd-tltp-elem', [['data-active', 'false']]);
      window.event.stopPropagation();
      Builder.$forceUpdate();
    },
    movePopUp: function movePopUp() {
      var overlay = document.querySelectorAll("sb-fs-boss");
      if (overlay.length > 0) {
        document.getElementById("wpbody-content").prepend(overlay[0]);
      }
    },
    checkObjectArrayElement: function checkObjectArrayElement(objectArray, object, byWhat) {
      var objectResult = objectArray.filter(function (elem) {
        return elem[byWhat] == object[byWhat];
      });
      return objectResult.length > 0 ? true : false;
    },
    getModerationShoppableMode: function getModerationShoppableMode() {
      if (this.viewsActive.moderationMode || this.customizerScreens.activeSection == 'settings_shoppable_feed') {
        this.moderationShoppableMode = true;
      } else {
        this.moderationShoppableMode = false;
      }
      return this.moderationShoppableMode;
    },
    getModerationShoppableModeOffset: function getModerationShoppableModeOffset() {
      return this.moderationShoppableModeOffset > 0;
    },
    formatSubscriberCount: function formatSubscriberCount(strings) {
      console.log(strings);
    },
    hasFeature: function hasFeature(feature_name) {
      var self = this;
      return self.license_tier_features.includes(feature_name);
    }
  });
  var extraData = _objectSpread(_objectSpread({}, customizer.extraData), {}, (_objectSpread2 = {
    $parent: _this,
    nonce: sbc_builder.nonce,
    template: sbc_builder.feedInitOutput,
    freeCtaShowFeatures: false,
    upgradeUrl: sbc_builder.upgradeUrl,
    supportPageUrl: sbc_builder.supportPageUrl,
    pluginURL: sbc_builder.pluginURL,
    builderUrl: sbc_builder.builderUrl,
    pluginType: sbc_builder.pluginType,
    genericText: sbc_builder.genericText,
    sourcesScreenText: sbc_builder.sourcesScreenText,
    apiKeyPopupScreen: sbc_builder.apiKeyPopupScreen,
    selectTemplate: sbc_builder.selectTemplate,
    ajaxHandler: sbc_builder.ajaxHandler,
    adminPostURL: sbc_builder.adminPostURL,
    welcomeScreen: sbc_builder.welcomeScreen,
    svgIcons: sbc_builder.svgIcons,
    license_tier_features: sbc_builder.license_tier_features,
    customizerFeedDataInitial: null,
    customizerFeedData: sbc_builder.customizerFeedData,
    customizerHeaderData: sbc_builder.headerData,
    iscustomizerScreen: sbc_builder.customizerFeedData != undefined && sbc_builder.customizerFeedData != false,
    selectFeedTypeScreen: sbc_builder.selectFeedTypeScreen,
    customizerSidebarBuilder: sbc_builder.customizerSidebarBuilder,
    feedTypes: sbc_builder.feedTypes,
    advancedFeedTypes: sbc_builder.advancedFeedTypes,
    extensionsPopup: sbc_builder.extensionsPopup,
    apiKeyStatus: sbc_builder.apiKeyStatus,
    connectedAccountStatus: sbc_builder.connectedAccountStatus,
    sbyAPIKey: null,
    apiKeyBtnLoader: false,
    apiKeyError: false,
    accessTokenError: false,
    feedStyle: '',
    isCreateProcessGood: false,
    socialWallActivated: sbc_builder.pluginsInfo.social_wall.activated,
    licenseKey: sbc_builder.licenseKey,
    sbyIsPro: sbc_builder.sbyIsPro === '1',
    sbyLicenseNoticeActive: sbc_builder.sbyLicenseNoticeActive === '1',
    sbyLicenseInactiveState: sbc_builder.sbyLicenseInactiveState === '1',
    socialWallAdminPage: sbc_builder.pluginsInfo.social_wall.settingsPage,
    recheckLicenseStatus: null,
    customizerScreens: {
      activeTab: 'customize',
      printedType: {},
      printedTemplate: {},
      activeSection: null,
      previewScreen: 'desktop',
      sourceExpanded: null,
      sourcesChoosed: [],
      inputNameWidth: '0px',
      activeSectionData: null,
      parentActiveSection: null,
      //For nested Setions
      parentActiveSectionData: null,
      //For nested Setions
      activeColorPicker: null
    },
    previewScreens: ['desktop', 'tablet', 'mobile'],
    nestedStylingSection: ['playicon_styling_title', 'video_styling_title', 'user_styling_title', 'views_styling_title', 'countdown_styling_title', 'stats_styling_title', 'date_styling_title', 'description_styling_title'],
    embedPopupScreen: sbc_builder.embedPopupScreen,
    customizeScreensText: sbc_builder.customizeScreens,
    highLightedSection: 'all',
    dummyLightBoxScreen: false,
    dialogBoxPopupScreen: sbc_builder.dialogBoxPopupScreen,
    selectFeedTemplateScreen: sbc_builder.selectFeedTemplateScreen,
    shouldShowFeedAPIBackBtn: false,
    dialogBox: {
      active: false,
      type: null,
      //deleteSourceCustomizer
      heading: null,
      description: null,
      customButtons: undefined
    },
    sourceToDelete: {},
    viewsActive: {
      //Screens where the footer widget is disabled
      footerDiabledScreens: ['welcome', 'selectFeed'],
      footerWidget: false,
      // welcome, selectFeed
      pageScreen: 'welcome',
      // feedsType, selectSource, feedsTypeGetProcess
      selectedFeedSection: 'feedsType',
      manualSourcePopupInit: sbc_builder.manualSourcePopupInit,
      sourcePopup: false,
      feedtypesPopup: false,
      feedtemplatesPopup: false,
      feedTemplateElement: null,
      feedtypesCustomizerPopup: false,
      sourcesListPopup: false,
      // step_1 [Add New Source] , step_2 [Connect to a user pages/groups], step_3 [Add Manually]
      sourcePopupScreen: 'redirect_1',
      extensionsPopupElement: false,
      // creation or customizer
      sourcePopupType: 'creation',
      accountAPIPopup: false,
      instanceFeedActive: null,
      clipboardCopiedNotif: false,
      legacyFeedsShown: false,
      editName: false,
      embedPopup: false,
      embedPopupScreen: 'step_1',
      embedPopupSelectedPage: null,
      // onboarding
      onboardingPopup: sbc_builder.allFeedsScreen.onboarding.active,
      onboardingStep: 1,
      licenseLearnMore: false,
      whyRenewLicense: false,
      // customizer onboarding
      onboardingCustomizerPopup: sbc_builder.customizeScreens.onboarding.active,
      // plugin install popup
      installPluginPopup: false,
      installPluginModal: 'facebook'
    },
    wordpressPageLists: sbc_builder.wordpressPageLists,
    widgetsPageURL: sbc_builder.widgetsPageURL,
    feedTemplates: sbc_builder.feedTemplates,
    selectedBulkAction: false,
    selectedFeed: 'channel',
    selectedFeedPopup: [],
    // Selected Feed Template
    selectedFeedTemplate: 'default',
    feedsSelected: []
  }, _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_objectSpread2, "extensionsPopup", sbc_builder.extensionsPopup), "tooltip", {
    text: '',
    hover: false,
    hoverType: 'outside'
  }), "activeExtensionsFull", sbc_builder.activeExtensions), "activeExtensions", []), "inActiveExtensions", []), "fullScreenLoader", false), "appLoaded", false), "previewLoaded", false), "loadingBar", true), "licenseBtnClicked", false), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_objectSpread2, "notificationElement", {
    type: 'success',
    // success, error, warning, message
    text: '',
    shown: null
  }), "feedPagination", {
    feedsCount: sbc_builder.feedsCount != undefined ? sbc_builder.feedsCount : null,
    pagesNumber: 1,
    currentPage: 1,
    itemsPerPage: sbc_builder.itemsPerPage != undefined ? sbc_builder.itemsPerPage : null
  }), "sw_feed", false), "sw_feed_id", false)));
  Vue.component(dummyLightBoxComponent, {
    template: '#' + dummyLightBoxComponent,
    props: ['customizerFeedData', 'parent', 'dummyLightBoxScreen', 'customizerHeaderData']
  });

  /**
   * VueJS Global App Builder
   *
   * @since 4.0
   */
  Builder = new Vue({
    el: '#sbc-builder-app',
    http: {
      emulateJSON: true,
      emulateHTTP: true
    },
    components: {
      'sketch-picker': sketch
    },
    mixins: [VueClickaway.mixin],
    data: extraData,
    updated: function updated() {
      var self = this;
      if (self.iscustomizerScreen) {
        this.setShortcodeGlobalSettings(true);
      }
    },
    computed: {
      feedStyleOutput: function feedStyleOutput() {
        return this.customizerStyleMaker();
      }
    },
    created: function created() {
      var _this3 = this;
      var self = this;
      var urlParams = new URLSearchParams(window.location.search);
      // get the socail wall link feed url params
      self.sw_feed = urlParams.get('sw-feed');
      self.sw_feed_id = urlParams.get('sw-feed-id');
      setTimeout(function () {
        var queryString = window.location.search,
          urlParams = new URLSearchParams(queryString),
          page = urlParams.get('page'),
          sby_access_token = urlParams.get('sby_access_token'),
          sby_refresh_token = urlParams.get('sby_refresh_token');
        self.loadingBar = false;
        _this3.$parent = self;
        if (self.customizerFeedData) {
          self.customizerFeedDataInitial = JSON.parse(JSON.stringify(self.customizerFeedData));
        }
        if (self.customizerFeedData == undefined) {
          self.feedPagination.pagesNumber = self.feedPagination.feedsCount != null ? Math.ceil(self.feedPagination.feedsCount / self.feedPagination.itemsPerPage) : 1;
        }

        // check if access token is available on the feed builder page then switch the screen
        if (page == 'sby-feed-builder' && sby_access_token && sby_refresh_token) {
          self.switchScreen('pageScreen', 'selectFeed');
          self.switchScreen('selectedFeedSection', 'selectSource');
        }
        self.activeExtensionsFull.map(function (element) {
          return self.activeExtensions[element['type']] = element['active'];
        });
        self.activeExtensionsFull.map(function (element) {
          if (element['active'] == false) {
            element['ids'].forEach(function (id) {
              self.inActiveExtensions[id] = element['type'];
            });
          }
        });
        /* Onboarding - move elements so the position is in context */
        self.positionOnboarding();
        document.querySelector('#sbc-builder-app').classList.add('initialized');
      }, 100);
    },
    methods: extraMethods
  });
});
})();

/******/ })()
;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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